%Cleaning/Sampling the Data, per burst plots
% Starts with the concentration

% Path of measurements

fileName = {'Guyana_MF901220200220164021'};
Path1    = 'F:\OBS_Calibration\';
Folder   = {'VEC12422_OBS9012_Mudflat\'};

file_name = 'Guyana_MF901220200220164021';
Path_full = strcat(Path1,'VEC12422_OBS9012_Mudflat\');

%% Pressure and velocity data
% Reading file
Data = dlmread(strcat(Path,file_name,'.dat'));
[nf, nc] = size(Data);

%%
%Concentration Analysis
clear all;
close all;

% Load the mat file from the read_ADVData script
load Guyana_MF901220200220164021.mat

% OBS data

% Conversion from counts to volts- Input 2 was only used*
ADVData.Data.Volt2  = (ADVData.Data.AnalogueInput2.*5)./65535;    

% Conversion from volts to NTU
ADVData.Data.NTU2  = 2.5920.*(ADVData.Data.Volt2).^2+...
    (91.163.*ADVData.Data.Volt2)-0.53091;

% Conversion from NTU to sediment concentration 
% Order of the ADVs: ADV =[1,2,3,4];
OBS        = [9012]; % serial number

%File where the calibration data is stored 
file_coeff = 'coefficients_fit'; % here you should refer to the calibration with your sediment
Path_coeff = strcat(Path_full);%'/Volumes/Seagate Backup Plus Drive/Data fieldwork/Calibration/';
load(strcat(Path_coeff,file_coeff,'.mat'))

% Calculating concentration using empirical relationships, g/l
Concentration_mudflat(:,1)  = polyval(fitResults2(1,:),(ADVData.Data.NTU2(:,1)).');


%This will remove the times when the instrument was not deployed/
%deployment
%And will replace the dry durations with NAN values


%Filtering the data
%SNR=5 & COR=70

% Spike Detection Filter

% Filtering of samples marked with a communications error flag

